// ===== STARBUCKS HACKER GAME - GRAPHICS EFFECTS =====

const GraphicsManager = {
    
    // Trigger screen glitch effect
    triggerGlitch() {
        const screens = document.querySelectorAll('.screen.active');
        screens.forEach(screen => {
            screen.style.animation = 'glitch-screen 0.3s ease';
            setTimeout(() => {
                screen.style.animation = '';
            }, 300);
        });
        
        // Add temporary RGB split
        document.body.classList.add('rgb-split');
        setTimeout(() => {
            document.body.classList.remove('rgb-split');
        }, 500);
    },
    
    // Money rain effect
    showMoneyRain() {
        const container = document.createElement('div');
        container.className = 'money-rain-container';
        container.style.cssText = `
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: 999;
            overflow: hidden;
        `;
        document.body.appendChild(container);
        
        const emojis = ['💵', '💰', '☕', '🤑', '💲'];
        
        for (let i = 0; i < 50; i++) {
            setTimeout(() => {
                const money = document.createElement('div');
                money.textContent = emojis[Math.floor(Math.random() * emojis.length)];
                money.style.cssText = `
                    position: absolute;
                    top: -50px;
                    left: ${Math.random() * 100}%;
                    font-size: ${20 + Math.random() * 30}px;
                    animation: fall ${2 + Math.random() * 3}s linear forwards;
                    opacity: 0.8;
                `;
                container.appendChild(money);
            }, i * 50);
        }
        
        setTimeout(() => {
            container.remove();
        }, 5000);
    },
    
    // Arrest screen effect
    triggerArrestEffect() {
        // Red flash
        const flash = document.createElement('div');
        flash.style.cssText = `
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: red;
            z-index: 9999;
            animation: arrest-flash 0.5s ease-out forwards;
            pointer-events: none;
        `;
        document.body.appendChild(flash);
        
        setTimeout(() => {
            flash.remove();
        }, 500);
        
        // Screen shake
        document.body.classList.add('shake');
        setTimeout(() => {
            document.body.classList.remove('shake');
        }, 500);
    },
    
    // Win celebration effect
    triggerWinEffect() {
        const container = document.createElement('div');
        container.className = 'confetti-container';
        container.style.cssText = `
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: 999;
            overflow: hidden;
        `;
        document.body.appendChild(container);
        
        const emojis = ['☕', '🎉', '🏆', '⭐', '🎊', '💚'];
        
        for (let i = 0; i < 100; i++) {
            setTimeout(() => {
                const confetti = document.createElement('div');
                confetti.textContent = emojis[Math.floor(Math.random() * emojis.length)];
                confetti.style.cssText = `
                    position: absolute;
                    top: -50px;
                    left: ${Math.random() * 100}%;
                    font-size: ${15 + Math.random() * 25}px;
                    animation: confetti-fall ${3 + Math.random() * 4}s linear forwards;
                    transform: rotate(${Math.random() * 360}deg);
                `;
                container.appendChild(confetti);
            }, i * 30);
        }
        
        // Green glow pulse
        document.body.classList.add('win-glow');
        
        setTimeout(() => {
            container.remove();
            document.body.classList.remove('win-glow');
        }, 7000);
    },
    
    // Matrix rain background
    createMatrixRain() {
        const canvas = document.createElement('canvas');
        canvas.className = 'matrix-bg';
        canvas.style.cssText = `
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            opacity: 0.15;
        `;
        document.body.appendChild(canvas);
        
        const ctx = canvas.getContext('2d');
        
        function resize() {
            canvas.width = window.innerWidth;
            canvas.height = window.innerHeight;
        }
        resize();
        window.addEventListener('resize', resize);
        
        const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789☕$€¥₿<>{}[]|\\/*-+=%@#&';
        const fontSize = 14;
        const columns = canvas.width / fontSize;
        const drops = Array(Math.floor(columns)).fill(1);
        
        function draw() {
            ctx.fillStyle = 'rgba(0, 0, 0, 0.05)';
            ctx.fillRect(0, 0, canvas.width, canvas.height);
            
            ctx.fillStyle = '#00ff41';
            ctx.font = fontSize + 'px monospace';
            
            for (let i = 0; i < drops.length; i++) {
                const char = chars[Math.floor(Math.random() * chars.length)];
                ctx.fillText(char, i * fontSize, drops[i] * fontSize);
                
                if (drops[i] * fontSize > canvas.height && Math.random() > 0.975) {
                    drops[i] = 0;
                }
                drops[i]++;
            }
            
            requestAnimationFrame(draw);
        }
        
        draw();
    },
    
    // Typing cursor effect
    addTypingCursor(element) {
        element.classList.add('typing-cursor');
    },
    
    removeTypingCursor(element) {
        element.classList.remove('typing-cursor');
    },
    
    // Scan line effect
    pulseElement(element) {
        element.style.animation = 'pulse 0.5s ease';
        setTimeout(() => {
            element.style.animation = '';
        }, 500);
    },
    
    // Terminal flicker
    flickerTerminal() {
        const terminal = document.querySelector('.terminal');
        if (terminal) {
            terminal.style.opacity = '0.7';
            setTimeout(() => {
                terminal.style.opacity = '1';
            }, 50);
            setTimeout(() => {
                terminal.style.opacity = '0.8';
            }, 100);
            setTimeout(() => {
                terminal.style.opacity = '1';
            }, 150);
        }
    }
};

// Add dynamic styles for effects
const effectStyles = document.createElement('style');
effectStyles.textContent = `
    @keyframes fall {
        0% {
            transform: translateY(0) rotate(0deg);
            opacity: 1;
        }
        100% {
            transform: translateY(100vh) rotate(720deg);
            opacity: 0;
        }
    }
    
    @keyframes confetti-fall {
        0% {
            transform: translateY(0) rotate(0deg) scale(1);
            opacity: 1;
        }
        100% {
            transform: translateY(100vh) rotate(1080deg) scale(0.5);
            opacity: 0;
        }
    }
    
    @keyframes arrest-flash {
        0% { opacity: 1; }
        100% { opacity: 0; }
    }
    
    @keyframes glitch-screen {
        0% { transform: translate(0); filter: hue-rotate(0deg); }
        20% { transform: translate(-5px, 5px); filter: hue-rotate(90deg); }
        40% { transform: translate(5px, -5px); filter: hue-rotate(180deg); }
        60% { transform: translate(-5px, -5px); filter: hue-rotate(270deg); }
        80% { transform: translate(5px, 5px); filter: hue-rotate(360deg); }
        100% { transform: translate(0); filter: hue-rotate(0deg); }
    }
    
    @keyframes pulse {
        0% { transform: scale(1); }
        50% { transform: scale(1.02); }
        100% { transform: scale(1); }
    }
    
    .shake {
        animation: shake 0.5s ease !important;
    }
    
    @keyframes shake {
        0%, 100% { transform: translateX(0); }
        10%, 30%, 50%, 70%, 90% { transform: translateX(-10px); }
        20%, 40%, 60%, 80% { transform: translateX(10px); }
    }
    
    .rgb-split {
        animation: rgb-split 0.3s ease !important;
    }
    
    @keyframes rgb-split {
        0% { filter: none; }
        25% { filter: drop-shadow(-3px 0 #ff0000) drop-shadow(3px 0 #00ffff); }
        50% { filter: drop-shadow(3px 0 #ff0000) drop-shadow(-3px 0 #00ffff); }
        75% { filter: drop-shadow(-2px 0 #ff0000) drop-shadow(2px 0 #00ffff); }
        100% { filter: none; }
    }
    
    .win-glow {
        animation: win-glow-pulse 1s ease infinite !important;
    }
    
    @keyframes win-glow-pulse {
        0%, 100% { 
            filter: drop-shadow(0 0 10px #00ff41);
        }
        50% { 
            filter: drop-shadow(0 0 30px #00ff41) drop-shadow(0 0 60px #00704A);
        }
    }
`;
document.head.appendChild(effectStyles);

// Initialize matrix rain on load
document.addEventListener('DOMContentLoaded', () => {
    GraphicsManager.createMatrixRain();
    
    // Random terminal flicker
    setInterval(() => {
        if (Math.random() > 0.95) {
            GraphicsManager.flickerTerminal();
        }
    }, 3000);
});

// Export for use in main.js
window.GraphicsManager = GraphicsManager;
